import 'dart:convert';

import 'package:chewie/chewie.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:play_lab/constants/constant_helper.dart';
import 'package:play_lab/constants/my_strings.dart';
import 'package:play_lab/core/helper/string_format_helper.dart';
import 'package:play_lab/core/route/route.dart';
import 'package:play_lab/core/utils/my_color.dart';
import 'package:play_lab/core/utils/styles.dart';
import 'package:play_lab/data/controller/tournament/tournament_live_chat_controller.dart';
import 'package:play_lab/data/model/dashboard/user_subcription_response_model.dart';
import 'package:play_lab/data/model/tournament/event_details_response.dart';
import 'package:play_lab/data/model/tournament/event_list_response_model.dart';
import 'package:play_lab/data/model/global/tournament/tournament_model.dart';
import 'package:play_lab/data/model/global/tournament/game_model.dart';
import 'package:play_lab/data/model/global/response_model/response_model.dart';
import 'package:play_lab/data/model/subscribe_plan/buy_subscribe_plan_response_model.dart';
import 'package:play_lab/data/repo/event/event_repo.dart';
import 'package:play_lab/view/components/show_custom_snackbar.dart';
import 'package:video_player/video_player.dart';

class TournamentController extends GetxController {
  TournamentRepo repo;
  TournamentLiveChatController liveChatController;
  TournamentController({
    required this.repo,
    required this.liveChatController,
  });

  bool isLoading = true;
  List<TournamentModel> events = [];
  String? nextPageUrl;
  int currentPage = 0;

  void initialData() async {
    currency = repo.apiClient.getCurrencyOrUsername(isCurrency: true);
    currencySym = repo.apiClient.getCurrencyOrUsername(isSymbol: true);

    try {
      ResponseModel responseModel = await repo.getEventList();
      if (responseModel.statusCode == 200) {
        TournamentListResponseModel model = TournamentListResponseModel.fromJson(jsonDecode(responseModel.responseJson));
        if (model.status == "success") {
          nextPageUrl = nextPageUrl;
          imagePath = model.data?.imagePath ?? '';
          events.addAll(model.data?.events?.data ?? []);
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: model.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
      }
    } catch (e) {
      printX(e.toString());
    }
    isLoading = false;
    update();
    if (repo.apiClient.isAuthorizeUser()) {
      loadSubscriptionData();
    }
  }

  bool hasNext() {
    return nextPageUrl != null && nextPageUrl!.isNotEmpty && nextPageUrl != 'null' ? true : false;
  }

  List<String> subscribeGameList = [];
  Future<void> loadSubscriptionData() async {
    printX('load all subscription id');

    ResponseModel responseModel = await repo.getSubscriptionData();

    if (responseModel.statusCode == 200) {
      UserSubscriptionResponseModel model = UserSubscriptionResponseModel.fromJson(jsonDecode(responseModel.responseJson));
      if (model.status == 'success') {
        subscribeGameList.addAll(model.data?.subscribedTournamentId ?? []);
        update();
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: model.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
      }
    } else {
      CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
    }
  }

  //

  late VideoPlayerController videoPlayerController;
  late ChewieController chewieController;
  TournamentModel event = TournamentModel(id: "-1");
  String imagePath = '';
  bool canPlay = false;
  List<GameModel> games = [];
  String currency = '';
  String currencySym = '';
  String videoUrl = '';
  Map<String, List<GameModel>> gamesMap = {};
  List<String> subscribedEventId = [];

  Future<void> getEventDetails(String id) async {
    isLoading = true;
    canPlay = false;
    currency = repo.apiClient.getCurrencyOrUsername(isCurrency: true);
    currencySym = repo.apiClient.getCurrencyOrUsername(isSymbol: true);
    games.clear();
    update();

    try {
      ResponseModel responseModel = await repo.getEventDetails(id);
      if (responseModel.statusCode == 200) {
        EventDetailsResponseModel model = EventDetailsResponseModel.fromJson(jsonDecode(responseModel.responseJson));
        if (model.status == "success") {
          event = model.data?.event ?? TournamentModel(id: "-1");
          canPlay = model.data?.watchEligible.toString() == "true" ? true : false;

          games.addAll(model.data?.event?.games ?? []);
          gamesMap.addAll(model.data?.games ?? {});
          imagePath = model.data?.imagePath ?? '';
          subscribedEventId.addAll(model.data?.subscribedMatchId ?? []);
          update();
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: model.message?.error ?? [MyStrings.somethingWentWrong], msg: [], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [responseModel.message], msg: [], isError: true);
      }
    } catch (e) {
      printX(e.toString());
    }
    isLoading = false;
    update();
  }

  @override
  void onClose() {
    try {
      videoPlayerController.dispose();
      chewieController.dispose();
    } catch (e) {
      printX(e.toString());
    }

    videoUrl = '';
    isLoading = true;
    super.onClose();
  }

  bool isInitialize = false;
  bool isVideoLoading = false;
  GameModel? playingGame;
  Future<dynamic> initializePlayer({
    required GameModel game,
  }) async {
    isVideoLoading = true;
    playingGame = game;
    update();
    // liveChatController.initWsSocketService(game.id.toString());
    videoPlayerController = VideoPlayerController.networkUrl(Uri.parse(game.link.toString()));

    try {
      await videoPlayerController.initialize();
      chewieController = ChewieController(
        videoPlayerController: videoPlayerController,
        aspectRatio: 4 / 2,
        autoPlay: true,
        isLive: true,
        allowedScreenSleep: false,
        allowFullScreen: true,
        looping: true,
        autoInitialize: true,
        showControls: true,
        allowMuting: false,
        additionalOptions: (c) => [],
        allowPlaybackSpeedChanging: false,
        errorBuilder: (context, error) {
          String errorMessage = '';
          if (error.contains('VideoError')) {
            errorMessage = MyStrings.videoSourceError;
          } else if (error.contains('PlatformException')) {
            errorMessage = MyStrings.platformSpecificError;
          } else {
            errorMessage = MyStrings.unknownVideoError;
          }
          return Padding(
            padding: const EdgeInsets.symmetric(horizontal: 15.0),
            child: Center(
              child: Text(
                errorMessage.tr,
                style: boldDefault.copyWith(color: MyColor.colorWhite),
                overflow: TextOverflow.ellipsis,
                maxLines: 2,
                textAlign: TextAlign.center,
              ),
            ),
          );
        },
      );

      chewieController.addListener(() {
        if (videoPlayerController.value.position == videoPlayerController.value.duration) {}
      });

      videoUrl = game.link.toString();
      isInitialize = true;
    } catch (e) {
      printX('error: ${e.toString()}');
    }
    isVideoLoading = false;
    isLoading = false;
    update();
  }

  bool isBuyPlanClick = false;
  Future<void> subscribeNow({bool isGame = false, String gId = '-1'}) async {
    isBuyPlanClick = true;
    update();
    try {
      ResponseModel response = await repo.buyEvent(isGame ? gId : (event.id ?? '-1'), isGame: isGame);
      if (response.statusCode == 200) {
        BuySubscribePlanResponseModel bModel = BuySubscribePlanResponseModel.fromJson(jsonDecode(response.responseJson));
        if (bModel.status == 'success') {
          String subId = bModel.data?.subscriptionId ?? '';
          update();
          Get.toNamed(RouteHelper.depositScreen, arguments: [event.price.toString(), event.name.toString(), subId, event.id.toString()]);
        } else {
          CustomSnackbar.showCustomSnackbar(errorList: [bModel.message?.error.toString() ?? MyStrings.failedToBuySubscriptionPlan], msg: [''], isError: true);
        }
      } else {
        CustomSnackbar.showCustomSnackbar(errorList: [response.message], msg: [], isError: true);
      }
    } catch (e) {
      PrintHelper.printHelper(e.toString());
    }
    isBuyPlanClick = false;
    update();
  }
}
